// Фильтрация по категориям
document.addEventListener('DOMContentLoaded', function() {
    const filterTabs = document.querySelectorAll('.filter-tab');
    const carCards = document.querySelectorAll('.car-card');
    
    // Обработчики для фильтров
    filterTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            const category = this.dataset.category;
            
            // Обновляем активную вкладку
            filterTabs.forEach(t => t.classList.remove('active'));
            this.classList.add('active');
            
            // Фильтруем карточки
            carCards.forEach(card => {
                if (category === 'all' || card.dataset.category === category) {
                    card.style.display = 'block';
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 50);
                } else {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';
                    setTimeout(() => {
                        card.style.display = 'none';
                    }, 300);
                }
            });
        });
    });
    
    // Избранное
    const wishlistBtns = document.querySelectorAll('.wishlist-btn');
    wishlistBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            this.classList.toggle('active');
            this.querySelector('i').classList.toggle('far');
            this.querySelector('i').classList.toggle('fas');
            
            const carName = this.closest('.car-card').querySelector('h3').textContent;
            if (this.classList.contains('active')) {
                console.log(`Добавлено в избранное: ${carName}`);
            } else {
                console.log(`Удалено из избранного: ${carName}`);
            }
        });
    });
});

// Функции для кнопок
function showPreorderModal(carModel) {
    const modal = document.getElementById('preorder-modal');
    const modalBody = modal.querySelector('.modal-body');
    
    const carData = {
        'terra-x1': {
            name: 'Subruit Terra X1',
            price: '7 200 000 ₽',
            image: 'SUV.jpg'
        },
        'terra-x3': {
            name: 'Subruit Terra X3', 
            price: '3 800 000 ₽',
            image: 'X3.jpg'
        },
        'terra-s1': {
            name: 'Subruit Terra S1',
            price: '12 900 000 ₽', 
            image: 'sedan.jpg'
        },
        'terra-gt': {
            name: 'Subruit Terra GT',
            price: '5 500 000 ₽',
            image: 'спорткар.jpg'
        },
        'terra-neo': {
            name: 'Subruit Terra MacLaren 1500',
            price: '25 000 000 ₽',
            image: 'giper.jpg'
        },
        'terra-s2': {
            name: 'Subruit Terra S2',
            price: '6 900 000 ₽',
            image: 'sportsedan.jpg'
        }
    };
    
    const car = carData[carModel];
    
    modalBody.innerHTML = `
        <div class="modal-preorder">
            <div class="modal-car-image">
                <img src="${car.image}" alt="${car.name}">
            </div>
            <h2>${car.name}</h2>
            <div class="modal-price">${car.price}</div>
            <p>Оставьте заявку на предзаказ этого автомобиля</p>
            
            <form class="preorder-form-simple" onsubmit="submitPreorder(event, '${carModel}')">
                <input type="text" name="name" placeholder="Ваше имя" required>
                <input type="tel" name="phone" placeholder="Ваш телефон" required>
                <input type="email" name="email" placeholder="Ваш email" required>
                
                <button type="submit" class="btn-primary large">
                    <i class="fas fa-paper-plane"></i>
                    Отправить заявку
                </button>
            </form>
        </div>
    `;
    
    modal.classList.add('active');
    document.body.style.overflow = 'hidden';
    
    // Закрытие модального окна
    const closeModal = document.getElementById('close-modal');
    closeModal.onclick = function() {
        modal.classList.remove('active');
        document.body.style.overflow = 'auto';
    };
    
    // Закрытие при клике вне окна
    modal.onclick = function(e) {
        if (e.target === modal) {
            modal.classList.remove('active');
            document.body.style.overflow = 'auto';
        }
    };
    
    // Маска для телефона
    const phoneInput = modal.querySelector('input[name="phone"]');
    phoneInput.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        
        if (value.length > 0) {
            value = '+7 (' + value;
            
            if (value.length > 7) {
                value = value.slice(0, 7) + ') ' + value.slice(7);
            }
            if (value.length > 12) {
                value = value.slice(0, 12) + '-' + value.slice(12);
            }
            if (value.length > 15) {
                value = value.slice(0, 15) + '-' + value.slice(15, 17);
            }
        }
        
        e.target.value = value;
    });
}

function submitPreorder(event, carModel) {
    event.preventDefault();
    
    const formData = new FormData(event.target);
    const data = {
        name: formData.get('name'),
        phone: formData.get('phone'),
        email: formData.get('email'),
        car: carModel,
        timestamp: new Date().toISOString()
    };
    
    // Отправка на сервер
    console.log('Заявка на предзаказ:', data);
    
    // Показываем сообщение
    alert('Спасибо! Ваша заявка на предзаказ принята. Мы свяжемся с вами в ближайшее время.');
    
    // Закрываем модальное окно
    document.getElementById('preorder-modal').classList.remove('active');
    document.body.style.overflow = 'auto';
    event.target.reset();
}

function showDetails(carModel) {
    // Переход на страницу деталей автомобиля
    window.location.href = `car-details.html?model=${carModel}`;
}

// Дополнительные стили для модального окна
const additionalStyles = `
.modal-preorder {
    text-align: center;
        font-family: Arial, Helvetica, sans-serif;

}

.modal-car-image {
    width: 100%;
    height: 200px;
    margin-bottom: 20px;
    border-radius: 10px;
    overflow: hidden;
}

.modal-car-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.modal-price {
    font-size: 28px;
    font-weight: bold;
    color: #000000ff;
    margin: 10px 0;
    font-family: Arial, Helvetica, sans-serif;
}

.preorder-form-simple {
    display: flex;
    flex-direction: column;
    gap: 15px;
    margin-top: 20px;
}

.preorder-form-simple input {
    padding: 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 16px;
    font-family: Arial, Helvetica, sans-serif;

}

.preorder-form-simple input:focus {
    outline: none;
    border-color: #000000ff;
}

.btn-primary.large {
    padding: 16px;
    font-size: 16px;
}
`;

// стили в документ
const styleSheet = document.createElement('style');
styleSheet.textContent = additionalStyles;
document.head.appendChild(styleSheet);
