document.addEventListener('DOMContentLoaded', function() {
    const preorderBtn = document.getElementById('preorder-btn');
    const preorderModal = document.getElementById('preorder-modal');
    const closeModal = document.getElementById('close-modal');
    const simpleForm = document.getElementById('simple-form');
    
    preorderBtn.addEventListener('click', function() {
        preorderModal.classList.add('active');
        document.body.style.overflow = 'hidden';
    });
    
    closeModal.addEventListener('click', function() {
        preorderModal.classList.remove('active');
        document.body.style.overflow = 'auto';
    });
    
    preorderModal.addEventListener('click', function(e) {
        if (e.target === preorderModal) {
            preorderModal.classList.remove('active');
            document.body.style.overflow = 'auto';
        }
    });
    
    simpleForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(simpleForm);
        const data = {
            name: formData.get('name'),
            phone: formData.get('phone'),
            email: formData.get('email'),
            car: 'BMW X7 xDrive40i',
            price: '8 900 000 ₽',
            timestamp: new Date().toISOString()
        };
        
        console.log('Заявка на предзаказ:', data);
        
        alert('Спасибо! Ваша заявка принята. Мы свяжемся с вами в течение 30 минут.');
        
        ///// Закрытие модального окна
        preorderModal.classList.remove('active');
        document.body.style.overflow = 'auto';
        simpleForm.reset();
    });
    
    //////// Маска для телефона
    const phoneInput = document.querySelector('input[name="phone"]');
    if (phoneInput) {
        phoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            
            if (value.length > 0) {
                value = '+7 (' + value;
                
                if (value.length > 7) {
                    value = value.slice(0, 7) + ') ' + value.slice(7);
                }
                if (value.length > 12) {
                    value = value.slice(0, 12) + '-' + value.slice(12);
                }
                if (value.length > 15) {
                    value = value.slice(0, 15) + '-' + value.slice(15, 17);
                }
            }
            
            e.target.value = value;
        });
    }
});